!Object constantsFor: 'Geos Libraries'!

geosLIB5 'SYSTEM\accpnt'! !

!Object constantsFor: 'Geos vardata'!

hintAccessPointControlMinimizeSize 27648!
attrAccessPointControlListMoniker 27652!
attrAccessPointControlSelection 27656!
attrAccessPointControlSecondLevelActive 27660!
hintAccessPointControlMultiselectable 27664!
!

!Object constantsFor: 'Geos messages'!

pointControlSetType 27648!
pointControlGetType 27649!
pointControlGetSelection 27650!
pointControlSetSelection 27651!
pointControlGetEditMsg 27652!
pointControlSetEditMsg 27653!
pointControlSendEditMsg 27654!
pointControlGetEnableDisable 27655!
pointControlSetEnableDisable 27656!
pointControlChangingLevels 27657!
pointControlUpdateSelection 27658!
pointControlGetNumSelections 27659!
pointControlGetMultipleSelections 27660!
!

!Geos class methodsFor: 'library calls'!

AccessPointCreateEntry: loc with: apt
	"word pascal AccessPointCreateEntry(word loc, AccessPointType apt) in accpnt.goh"
	^GEOS call: loc with: apt with: #[5 0 14 1 1 1]!

AccessPointDestroyEntry: id
	"Boolean pascal AccessPointDestroyEntry(word id) in accpnt.goh"
	^GEOS call: id with: #[5 0 15 1 4]!

AccessPointGetType: id
	"AccessPointType pascal AccessPointGetType(word id) in accpnt.goh"
	^GEOS call: id with: #[5 0 16 1 1]!

AccessPointSetStringProperty: id with: prop with: val
	"Boolean pascal AccessPointSetStringProperty(word id, char *prop, char *val) in accpnt.goh"
	^GEOS call: id with: prop with: val with: #[5 0 17 1 3 3 4]!

AccessPointSetIntegerProperty: id with: prop with: val
	"Boolean pascal AccessPointSetIntegerProperty(word id, char *prop, int val) in accpnt.goh"
	^GEOS call: id with: prop with: val with: #[5 0 18 1 3 4 4]!

AccessPointGetStringPropertyBlock: id with: prop with: data with: datalen
	"Boolean pascal AccessPointGetStringPropertyBlock(word id, char *prop, MemHandle *data, int *datalen) in accpnt.goh"
	^GEOS call: id with: prop with: data with: datalen with: #[5 0 19 1 3 3 3 4]!

AccessPointGetStringPropertyBuffer: id with: prop with: buf with: datalen
	"Boolean pascal AccessPointGetStringPropertyBuffer(word id, char *prop, char *buf, int *datalen) in accpnt.goh"
	^GEOS call: id with: prop with: buf with: datalen with: #[5 0 20 1 3 3 3 4]!

AccessPointGetIntegerProperty: id with: prop with: val
	"Boolean pascal AccessPointGetIntegerProperty(word id, char *prop, int *val) in accpnt.goh"
	^GEOS call: id with: prop with: val with: #[5 0 21 1 3 3 4]!

AccessPointDestroyProperty: id with: prop
	"Boolean pascal AccessPointDestroyProperty(word id, char *prop) in accpnt.goh"
	^GEOS call: id with: prop with: #[5 0 22 1 3 4]!

AccessPointGetEntries: mh with: chunk with: apt
	"ChunkHandle pascal AccessPointGetEntries(MemHandle mh, ChunkHandle chunk, AccessPointType apt) in accpnt.goh"
	^GEOS call: mh with: chunk with: apt with: #[5 0 23 1 1 1 1]!

AccessPointCompareStandardProperty: prop with: str
	"Boolean pascal AccessPointCompareStandardProperty(AccessPointStandardProperty prop, char *str) in accpnt.goh"
	^GEOS call: prop with: str with: #[5 0 24 1 3 4]!

AccessPointCommit
	"void pascal AccessPointCommit(void) in accpnt.goh"
	^GEOS call: #[5 0 25 0]!

AccessPointIsEntryValid: id
	"Boolean pascal AccessPointIsEntryValid(word id) in accpnt.goh"
	^GEOS call: id with: #[5 0 27 1 4]!

AccessPointLock: id
	"void pascal AccessPointLock (word id) in accpnt.goh"
	^GEOS call: id with: #[5 0 30 1 0]!

AccessPointUnlock: id
	"void pascal AccessPointUnlock (word id) in accpnt.goh"
	^GEOS call: id with: #[5 0 31 1 0]!

AccessPointInUse: id
	"Boolean pascal AccessPointInUse (word id) in accpnt.goh"
	^GEOS call: id with: #[5 0 33 1 4]!

!

GenControl subclass: #AccessPointControl
	instanceVariableNames: ''
	classVariableNames: ''!

!AccessPointControl comment!
Library accpnt, file accpnt.goh! !

!AccessPointControl class methodsFor: 'library linkage'!

library
	^5!

entry
	^11!
!

!AccessPointControl methodsFor: 'Geos instance variables'!

apciType
	"@instance AccessPointType APCI_type"
	^self wordAt: 25!

apciType: value
	"@instance AccessPointType APCI_type"
	^self wordAt: 25 put: value!

apciEditMsg
	"@instance word APCI_editMsg"
	^self wordAt: 27!

apciEditMsg: value
	"@instance word APCI_editMsg"
	^self wordAt: 27 put: value!

apciDefineParent
	"@instance optr APCI_defineParent"
	^self dwordAt: 29!

apciDefineParent: value
	"@instance optr APCI_defineParent"
	^self dwordAt: 29 put: value!

apciDefineSlot
	"@instance word APCI_defineSlot"
	^self wordAt: 33!

apciDefineSlot: value
	"@instance word APCI_defineSlot"
	^self wordAt: 33 put: value!

apciEnableDisable
	"@instance optr APCI_enableDisable"
	^self dwordAt: 35!

apciEnableDisable: value
	"@instance optr APCI_enableDisable"
	^self dwordAt: 35 put: value!

apciAltBitmap
	"@instance word APCI_altBitmap"
	^self wordAt: 39!

apciAltBitmap: value
	"@instance word APCI_altBitmap"
	^self wordAt: 39 put: value!

!

!AccessPointControl methodsFor: 'Geos vardata'!

hintAccessPointControlMinimizeSize
	"@vardata void HINT_ACCESS_POINT_CONTROL_MINIMIZE_SIZE"
	^self addVardata: ##hintAccessPointControlMinimizeSize!

attrAccessPointControlListMoniker: value
	"@vardata ChunkHandle ATTR_ACCESS_POINT_CONTROL_LIST_MONIKER"
	^self addVardata: ##attrAccessPointControlListMoniker word: value!

attrAccessPointControlSelection: value
	"@vardata word ATTR_ACCESS_POINT_CONTROL_SELECTION"
	^self addVardata: ##attrAccessPointControlSelection word: value!

attrAccessPointControlSecondLevelActive
	"@vardata void ATTR_ACCESS_POINT_CONTROL_SECOND_LEVEL_ACTIVE"
	^self addVardata: ##attrAccessPointControlSecondLevelActive!

hintAccessPointControlMultiselectable
	"@vardata void HINT_ACCESS_POINT_CONTROL_MULTISELECTABLE"
	^self addVardata: ##hintAccessPointControlMultiselectable!

!

!AccessPointControl methodsFor: 'Geos messages'!

pointControlSetType: apt
	"@message void MSG_ACCESS_POINT_CONTROL_SET_TYPE(AccessPointType apt = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: apt!

pointControlGetType
	"@message AccessPointType MSG_ACCESS_POINT_CONTROL_GET_TYPE()= ax"
	^self geosMessage: #[108 1 98 0 1]!

pointControlGetSelection
	"@message word MSG_ACCESS_POINT_CONTROL_GET_SELECTION()= ax"
	^self geosMessage: #[108 2 98 0 1]!

pointControlSetSelection: id
	"@message void MSG_ACCESS_POINT_CONTROL_SET_SELECTION(word id = cx)"
	^self geosMessage: #[108 3 2 5 1 0] with: id!

pointControlGetEditMsg
	"@message word MSG_ACCESS_POINT_CONTROL_GET_EDIT_MSG()= ax"
	^self geosMessage: #[108 4 98 0 1]!

pointControlSetEditMsg: msg
	"@message void MSG_ACCESS_POINT_CONTROL_SET_EDIT_MSG(word msg = cx)"
	^self geosMessage: #[108 5 2 5 1 0] with: msg!

pointControlSendEditMsg: id
	"@message void MSG_ACCESS_POINT_CONTROL_SEND_EDIT_MSG(word id = cx)"
	^self geosMessage: #[108 6 2 5 1 0] with: id!

pointControlGetEnableDisable
	"@message optr MSG_ACCESS_POINT_CONTROL_GET_ENABLE_DISABLE()= cx:dx"
	^self geosMessage: #[108 7 154 0 2]!

pointControlSetEnableDisable: obj
	"@message void MSG_ACCESS_POINT_CONTROL_SET_ENABLE_DISABLE(optr obj = cx:dx)"
	^self geosMessage: #[108 8 2 53 2 0] with: obj!

pointControlChangingLevels
	"@message void MSG_ACCESS_POINT_CONTROL_CHANGING_LEVELS()"
	^self geosMessage: #[108 9 2 0 0]!

pointControlUpdateSelection: index with: num
	"@message word MSG_ACCESS_POINT_CONTROL_UPDATE_SELECTION(word index = cx, word num = bp)= cx"
	^self geosMessage: #[108 10 102 61 1 1 1] with: index with: num!

pointControlGetNumSelections
	"@message word MSG_ACCESS_POINT_CONTROL_GET_NUM_SELECTIONS()= ax"
	^self geosMessage: #[108 11 98 0 1]!

pointControlGetMultipleSelections: buffer with: maxIDs
	"@message word MSG_ACCESS_POINT_CONTROL_GET_MULTIPLE_SELECTIONS( word *buffer = cx:dx, word maxIDs = bp)= ax"
	^self geosMessage: #[108 12 99 245 3 1 1] with: buffer with: maxIDs!

!

